package game;

import java.awt.Color;
import java.awt.Graphics;


public class BulletSprite {
	
	
	public static final int BULLET_SPEED = 10;
	public static final int BULLET_Y_SPREAD = 2;
	public static final int BULLET_X_SPREAD = 9;
	
	private char direction;
	private boolean friendly;
	private CustomImageDataII image;
	private int damage;
	private int originatingPony;
	private boolean shouldSpawnHeart;
	
	private int xPos, yPos;
	
	private CustomImageDataII animation[] = null;
	private int animationFrame = 0;
	
	public BulletSprite(boolean isFriendly, int fromCharacter, char theDir, int xStart, int yStart, BulletImageManager bim, PonyPanel ponyPanel) {
		
		friendly = isFriendly;
		originatingPony = fromCharacter;
		
		switch(fromCharacter) {
		case PlayerSprite.APPLEJACK:
			image = bim.getApplejackBulletImage();
			if(image == null) {
//				ii = new ImageIcon(BulletSprite.class.getResource("images/bullet/AJ2.GIF"));
//				image = new CustomImageData(ii.getImage(), 15,15, Color.white, ponyPanel); //ii.getIconWidth(), ii.getIconHeight(),
				image = new CustomImageDataII("/images/bullet/AJ2.GIF", Color.white, ponyPanel);
			}
			damage = PlayerSprite.APPLEJACK_DAMAGE;
			break;
		case PlayerSprite.FLUTTERSHY:
			image = bim.getFluttershyBulletImage();
			if(image == null) {
//				ii = new ImageIcon(BulletSprite.class.getResource("images/bullet/FS2.GIF"));
//				image = new CustomImageData(ii.getImage(), 15,15, Color.white, ponyPanel);
				image = new CustomImageDataII("/images/bullet/FS2.GIF", Color.white, ponyPanel);
			}
			damage = PlayerSprite.FLUTTERSHY_DAMAGE;
			break;
		case PlayerSprite.PINKIE_PIE:
			image = bim.getPinkiePieBulletImage();
			if(image == null) {
//				ii = new ImageIcon(BulletSprite.class.getResource("images/bullet/PP2.GIF"));
//				image = new CustomImageData(ii.getImage(), 15,15, Color.white, ponyPanel);
				image = new CustomImageDataII("/images/bullet/PP2.GIF", Color.white, ponyPanel);
			}
			damage = PlayerSprite.PINKIE_PIE_DAMAGE;
			break;
		case PlayerSprite.RAINBOW_DASH:
//			image = bim.getRainbowDashBulletImage();
			image = null;
			if(image == null) {
//				ii = new ImageIcon(BulletSprite.class.getResource("images/bullet/RD2.GIF"));
//				image = new CustomImageData(ii.getImage(), 15,15, Color.white, ponyPanel);
//				image = new CustomImageData(bim.getRainbowDashBulletImage().getImage(), 15, 15, null, ponyPanel);
				image = new CustomImageDataII("/images/bullet/RD2.GIF", Color.white, ponyPanel);
			}
			damage = PlayerSprite.RAINBOW_DASH_DAMAGE;
			break;
		case PlayerSprite.RARITY:
			image = bim.getRarityBulletImage();
			if(image == null) {
//				ii = new ImageIcon(BulletSprite.class.getResource("images/bullet/R2.GIF"));
//				image = new CustomImageData(ii.getImage(), 15,15, Color.white, ponyPanel);
				image = new CustomImageDataII("/images/bullet/R2.GIF", Color.white, ponyPanel);
			}
			damage = PlayerSprite.RARITY_DAMAGE;
			break;
		case PlayerSprite.TWILIGHT:
			image = bim.getTwilightBulletImage();
			if(image == null) {
//				ii = new ImageIcon(BulletSprite.class.getResource("images/bullet/TS2.GIF"));
//				image = new CustomImageData(ii.getImage(), 15,15, Color.white, ponyPanel);
				image = new CustomImageDataII("/images/bullet/TS2.GIF", Color.white, ponyPanel);
			}
			damage = PlayerSprite.TWILIGHT_DAMAGE;
			break;
		default:
			image = bim.getEnemyBulletImage();
			if(image == null) {
//				ii = new ImageIcon(BulletSprite.class.getResource("images/bullet/enemy2.GIF"));
//				image = new CustomImageData(ii.getImage(), 15,15, Color.white, ponyPanel);
				image = new CustomImageDataII("/images/bullet/enemy2.GIF", Color.white, ponyPanel);
			}
			damage = 1;
			break;
		}
		
		direction = theDir;
		xPos = xStart;
		yPos = yStart;
		
		
	}
	
	
	public void update() {
		
		switch(direction) {
		case 'l':
			xPos -= BULLET_SPEED;
			break;
		case 'w':
			xPos -= BULLET_X_SPREAD;
			yPos += BULLET_Y_SPREAD;
			break;
		case 'p':
			xPos -= BULLET_X_SPREAD;
			yPos -= BULLET_Y_SPREAD;
			break;
		case 'r':
			xPos += BULLET_SPEED;
			break;
		case 'e':
			xPos += BULLET_X_SPREAD;
			yPos += BULLET_Y_SPREAD;
			break;
		case 's':
			xPos += BULLET_X_SPREAD;
			yPos -= BULLET_Y_SPREAD;
			break;
		}
		
		if(animation != null) {
			animationFrame++;
			if(animationFrame >= animation.length)
				animationFrame = 0;
		}
		
		
	}
	
	public boolean canErase(PlayerSprite player, int panelWidth, int panelHeight) {

		return Math.abs(player.getxPos() - xPos) > panelWidth * 2 / 3;
		
	}
	
	public IntRect getCollisionRect() {
		
		if(animation == null)
			return new IntRect(xPos - image.getDesiredWidth() / 2, yPos - image.getDesiredHeight() / 2, image.getDesiredWidth(), image.getDesiredHeight());
		else
			return new IntRect(xPos - animation[0].getDesiredWidth() / 2, yPos - animation[0].getDesiredHeight() / 2, animation[0].getDesiredWidth(), animation[0].getDesiredHeight());
	}
	
	public void draw(Graphics g, int playerX, int playerY, int panelWidth, int panelHeight) {
		
		if(animation != null) {
			animation[animationFrame].drawObject(g, panelWidth/2 + (xPos - playerX) , panelHeight/2 + (yPos - playerY));
		} else {
			image.drawObject(g, panelWidth/2 + (xPos - playerX) , panelHeight/2 + (yPos - playerY));
		}
	}
	
	public int getDamage() {
		return damage;
	}
	
	public boolean isFriendly() {
		return friendly;
	}
	
	public int getOriginatingPony() {
		return originatingPony;
	}
	
	
	
	
	public BulletSprite(boolean isFriendly, char theDir, int xStart, int yStart, PonyPanel ponyPanel, CustomPlayableCharacterData customCharData) {
		
		friendly = isFriendly;
		originatingPony = PlayerSprite.CUSTOM;
		
		animation = customCharData.getBulletAnimation();
		damage = customCharData.getAttackPower();
		shouldSpawnHeart = customCharData.isShotsShouldSpawnHearts();
		
		direction = theDir;
		xPos = xStart;
		yPos = yStart;
		
		
	}
	
	public boolean shouldSpawnHeart() {
		return shouldSpawnHeart;
	}
	
}
